(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     10305,        362]*)
(*NotebookOutlinePosition[     11147,        389]*)
(*  CellTagsIndexPosition[     11103,        385]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
    \(\(\( (*\ Example\ 9.5 \( \(.2\)\(.\)\)\ *) \)\( (*\ 
      Roots\ of\ JacobiP[20, \(-0.34\), \(-0.66\), x]\ , \ 
      which\ are\ denoted\ by\ s_j\ \ *) \)\(\[IndentingNewLine]\)\(FindRoot[
      JacobiP[20, \(-0.34\), \(-0.66\), x] \[Equal] \ 0, \ {x, 
        0}]\)\)\)], "Input"],

Cell[BoxData[
    \({x \[Rule] 0.22101522868641255`}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindRoot[
      JacobiP[20, \(-0.34\), \(-0.66\), x] \[Equal] \ 0, \ {x, 
        0.3}]\)], "Input"],

Cell[BoxData[
    \({x \[Rule] 0.7520094530765514`}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindRoot[
      JacobiP[20, \(-0.34\), \(-0.66\), x] \[Equal] \ 0, \ {x, 
        0.4}]\)], "Input"],

Cell[BoxData[
    \({x \[Rule] 0.37085573045005343`}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindRoot[
      JacobiP[20, \(-0.34\), \(-0.66\), x] \[Equal] \ 0, \ {x, 
        0.5}]\)], "Input"],

Cell[BoxData[
    \({x \[Rule] 0.5115596301071592`}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindRoot[
      JacobiP[20, \(-0.34\), \(-0.66\), x] \[Equal] \ 0, \ {x, 
        0.6}]\)], "Input"],

Cell[BoxData[
    \({x \[Rule] 0.6396622182099022`}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindRoot[
      JacobiP[20, \(-0.34\), \(-0.66\), x] \[Equal] \ 0, \ {x, 
        0.7}]\)], "Input"],

Cell[BoxData[
    \({x \[Rule] 0.9188284878287604`}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindRoot[
      JacobiP[20, \(-0.34\), \(-0.66\), x] \[Equal] \ 0, \ {x, 
        0.85}]\)], "Input"],

Cell[BoxData[
    \({x \[Rule] 0.8458348437454533`}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindRoot[
      JacobiP[20, \(-0.34\), \(-0.66\), x] \[Equal] \ 0, \ {x, 
        0.9}]\)], "Input"],

Cell[BoxData[
    \({x \[Rule] 0.9188284695828041`}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindRoot[
      JacobiP[20, \(-0.34\), \(-0.66\), x] \[Equal] \ 0, \ {x, 
        0.95}]\)], "Input"],

Cell[BoxData[
    \({x \[Rule] 0.9957016076844202`}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindRoot[
      JacobiP[20, \(-0.34\), \(-0.66\), x] \[Equal] \ 0, \ {x, 
        0.96}]\)], "Input"],

Cell[BoxData[
    \({x \[Rule] 0.9691939953368223`}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindRoot[
      JacobiP[20, \(-0.34\), \(-0.66\), x] \[Equal] \ 0, \ {x, 
        0.1}]\)], "Input"],

Cell[BoxData[
    \({x \[Rule] 0.06572782377023653`}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindRoot[
      JacobiP[20, \(-0.34\), \(-0.66\), x] \[Equal] \ 
        0, \ {x, \(-0.1\)}]\)], "Input"],

Cell[BoxData[
    \({x \[Rule] \(-0.09118299296155699`\)}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindRoot[
      JacobiP[20, \(-0.34\), \(-0.66\), x] \[Equal] \ 
        0, \ {x, \(-0.2\)}]\)], "Input"],

Cell[BoxData[
    \({x \[Rule] \(-0.245853670438386`\)}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindRoot[
      JacobiP[20, \(-0.34\), \(-0.66\), x] \[Equal] \ 
        0, \ {x, \(-0.3\)}]\)], "Input"],

Cell[BoxData[
    \({x \[Rule] \(-0.24585349566122766`\)}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindRoot[
      JacobiP[20, \(-0.34\), \(-0.66\), x] \[Equal] \ 
        0, \ {x, \(-0.35\)}]\)], "Input"],

Cell[BoxData[
    \({x \[Rule] \(-0.39447517231678525`\)}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindRoot[
      JacobiP[20, \(-0.34\), \(-0.66\), x] \[Equal] \ 
        0, \ {x, \(-0.5\)}]\)], "Input"],

Cell[BoxData[
    \({x \[Rule] \(-0.5333883910725032`\)}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindRoot[
      JacobiP[20, \(-0.34\), \(-0.66\), x] \[Equal] \ 
        0, \ {x, \(-0.6\)}]\)], "Input"],

Cell[BoxData[
    \({x \[Rule] \(-0.998025514671348`\)}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindRoot[
      JacobiP[20, \(-0.34\), \(-0.66\), x] \[Equal] \ 
        0, \ {x, \(-0.7\)}]\)], "Input"],

Cell[BoxData[
    \({x \[Rule] \(-0.6591725558060938`\)}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindRoot[
      JacobiP[20, \(-0.34\), \(-0.66\), x] \[Equal] \ 
        0, \ {x, \(-0.8\)}]\)], "Input"],

Cell[BoxData[
    \({x \[Rule] \(-0.7687310300294197`\)}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindRoot[
      JacobiP[20, \(-0.34\), \(-0.66\), x] \[Equal] \ 
        0, \ {x, \(-0.85\)}]\)], "Input"],

Cell[BoxData[
    \({x \[Rule] \(-0.859365246194557`\)}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindRoot[
      JacobiP[20, \(-0.34\), \(-0.66\), x] \[Equal] \ 
        0, \ {x, \(-0.9\)}]\)], "Input"],

Cell[BoxData[
    \({x \[Rule] \(-0.9754533205824382`\)}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindRoot[
      JacobiP[20, \(-0.34\), \(-0.66\), x] \[Equal] \ 
        0, \ {x, \(-0.91\)}]\)], "Input"],

Cell[BoxData[
    \({x \[Rule] \(-0.9288434838931422`\)}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\( (*\ 
      P = \ \(\(-\ Sin[\[Pi]\[Alpha]]\) = 
          Sin[0.34\ \[Pi]]\)\ *) \)\(\[IndentingNewLine]\)\(Sin[
      0.34\ \[Pi]]\)\)\)], "Input"],

Cell[BoxData[
    \(0.8763066800438637`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(\( (*\ 
      Exact\ p[x] = \(\((1 - 
                  x)\)^\((\(-0.34\))\)*\((1 + 
                    x)\)^\((\(-0.66\))\) . \[IndentingNewLine]This\ means\ \
exact\ g[x] = \(1\ \[IndentingNewLine]For\ this\ problem\ a = 
            cot[\((\[Alpha] + 1)\) \[Pi]]\)\), \ 
      and\ b = \(-1\)\ *) \)\(\[IndentingNewLine]\)\(pexact[
          x_] := \((1 - x)\)^\((\(-0.34\))\)*\((1 + 
                x)\)^\((\(-0.66\))\);\)\)\)], "Input"],

Cell[BoxData[{
    \(\(s[1] = 0.99570161;\)\), "\[IndentingNewLine]", 
    \(\(s[2] = 0.96919398;\)\), "\[IndentingNewLine]", 
    \(\(s[3] = 0.91882847;\)\), "\[IndentingNewLine]", 
    \(\(s[4] = 0.84583484;\)\), "\[IndentingNewLine]", 
    \(\(s[5] = 0.75200941;\)\), "\[IndentingNewLine]", 
    \(\(s[6] = 0.63966222;\)\), "\[IndentingNewLine]", 
    \(\(s[7] = 0.51155956;\)\), "\[IndentingNewLine]", 
    \(\(s[8] = 0.37085573;\)\), "\[IndentingNewLine]", 
    \(\(s[9] = 0.22101530;\)\), "\[IndentingNewLine]", 
    \(\(s[10] = 0.06572782;\)\), "\[IndentingNewLine]", 
    \(\(s[11] = \(-0.09118299\);\)\), "\[IndentingNewLine]", 
    \(\(s[12] = \(-0.24585350\);\)\), "\[IndentingNewLine]", 
    \(\(s[13] = \(-0.39447517\);\)\), "\[IndentingNewLine]", 
    \(\(s[14] = \(-0.53338846\);\)\), "\[IndentingNewLine]", 
    \(\(s[15] = \(-0.65917283\);\)\), "\[IndentingNewLine]", 
    \(\(s[16] = \(-0.76873102\);\)\), "\[IndentingNewLine]", 
    \(\(s[17] = \(-0.85936525\);\)\), "\[IndentingNewLine]", 
    \(\(s[18] = \(-0.92884347\);\)\), "\[IndentingNewLine]", 
    \(\(s[19] = \(-0.97545332\);\)\), "\[IndentingNewLine]", 
    \(\(s[20] = \(-0.99802548\);\)\), "\[IndentingNewLine]", 
    \(\(x[1] = 0.98941625;\)\), "\[IndentingNewLine]", 
    \(\(x[2] = 0.95469739;\)\), "\[IndentingNewLine]", 
    \(\(x[3] = 0.89647074;\)\), "\[IndentingNewLine]", 
    \(\(x[4] = 0.81616593;\)\), "\[IndentingNewLine]", 
    \(\(x[5] = 0.71575974;\)\), "\[IndentingNewLine]", 
    \(\(x[6] = 0.59772435;\)\), "\[IndentingNewLine]", 
    \(\(x[7] = 0.46496613;\)\), "\[IndentingNewLine]", 
    \(\(x[8] = 0.32075402;\)\), "\[IndentingNewLine]", 
    \(\(x[9] = 0.16863897;\)\), "\[IndentingNewLine]", 
    \(\(x[10] = 0.01236655;\)\), "\[IndentingNewLine]", 
    \(\(x[11] = \(-0.14421527\);\)\), "\[IndentingNewLine]", 
    \(\(x[12] = \(-0.29725094\);\)\), "\[IndentingNewLine]", 
    \(\(x[13] = \(-0.44297222\);\)\), "\[IndentingNewLine]", 
    \(\(x[14] = \(-0.57779094\);\)\), "\[IndentingNewLine]", 
    \(\(x[15] = \(-0.69838740\);\)\), "\[IndentingNewLine]", 
    \(\(x[16] = \(-0.80179206\);\)\), "\[IndentingNewLine]", 
    \(\(x[17] = \(-0.88545862\);\)\), "\[IndentingNewLine]", 
    \(\(x[18] = \(-0.94732641\);\)\), "\[IndentingNewLine]", 
    \(\(x[19] = \(-0.98586873\);\)\), "\[IndentingNewLine]", 
    \(\(x[20] = 0.0;\)\[IndentingNewLine] (*\ 
      Use\ \[IndentingNewLine]A[i_, j_] := \ 
        2\ \((1 - s[j])\)/\((41\ \((s[j] - x[i])\))\); \[IndentingNewLine]a = 
        Table[A[i, j], \ {i, 20}, \ {j, 20}]\[IndentingNewLine]see\ krenk2 . 
            nb\ *) \)}], "Input"]
},
FrontEndVersion->"4.0 for Macintosh",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{520, 482},
WindowMargins->{{1, Automatic}, {Automatic, 1}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 303, 5, 75, "Input"],
Cell[2045, 58, 66, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2148, 64, 120, 3, 27, "Input"],
Cell[2271, 69, 65, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2373, 75, 120, 3, 27, "Input"],
Cell[2496, 80, 66, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2599, 86, 120, 3, 27, "Input"],
Cell[2722, 91, 65, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2824, 97, 120, 3, 27, "Input"],
Cell[2947, 102, 65, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3049, 108, 120, 3, 27, "Input"],
Cell[3172, 113, 65, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3274, 119, 121, 3, 27, "Input"],
Cell[3398, 124, 65, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3500, 130, 120, 3, 27, "Input"],
Cell[3623, 135, 65, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3725, 141, 121, 3, 27, "Input"],
Cell[3849, 146, 65, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3951, 152, 121, 3, 43, "Input"],
Cell[4075, 157, 65, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4177, 163, 120, 3, 27, "Input"],
Cell[4300, 168, 66, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4403, 174, 125, 3, 43, "Input"],
Cell[4531, 179, 71, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4639, 185, 125, 3, 43, "Input"],
Cell[4767, 190, 69, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4873, 196, 125, 3, 43, "Input"],
Cell[5001, 201, 71, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5109, 207, 126, 3, 43, "Input"],
Cell[5238, 212, 71, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5346, 218, 125, 3, 43, "Input"],
Cell[5474, 223, 70, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5581, 229, 125, 3, 43, "Input"],
Cell[5709, 234, 69, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5815, 240, 125, 3, 43, "Input"],
Cell[5943, 245, 70, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6050, 251, 125, 3, 43, "Input"],
Cell[6178, 256, 70, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6285, 262, 126, 3, 43, "Input"],
Cell[6414, 267, 69, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6520, 273, 125, 3, 43, "Input"],
Cell[6648, 278, 70, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6755, 284, 126, 3, 43, "Input"],
Cell[6884, 289, 70, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6991, 295, 173, 4, 43, "Input"],
Cell[7167, 301, 53, 1, 26, "Output"]
}, Open  ]],
Cell[7235, 305, 465, 9, 75, "Input"],
Cell[7703, 316, 2598, 44, 715, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

